 ; Ŀ
 ;   DDX - call the appropriate command to edit various text-like things.  
 ;   Copyright 1995, 1999, 2006 by Rocket Software Ltd.                    
 ;   Donald Duck Ears - another failure of product development.            
 ; 

 ; Ŀ
 ;   Subroutine Isfo - see if a text entity uses a given font.             
 ;   Arguments: Enam, the entity ename.                                    
 ;              Fona, the font name.                                       
 ;   Returns T or nil according to strange standards of its own.           
 ; 
 (DEFUN ISFO (enam fona / stylo fooon)
  (setq stylo (cdr (assoc 7 (entget enam))))
  (setq fooon (strcase (cdr (assoc 3 (tblsearch "style" stylo)))))
 (= fooon (strcase fona)))
 ; Ŀ
 ;   Subroutine Isfo end.                                                  
 ; 

 ; Ŀ
 ;   Pixx - find the size of a drawing unit in pixels.                     
 ; 
 (DEFUN PIXX (/ vsize scsize)
  (setq scsize (getvar "screensize"))       ; view wid & ht in pixels
  (setq vsize (getvar "viewsize"))          ; view height in dwg units
 (/ (cadr scsize) vsize))                   ; drawing unit size in pixels
 ; Ŀ
 ;   Pixx end.                                                             
 ; 

 ; Ŀ
 ;   Tibb - return the height of a text entity in pixels.                  
 ; 
 (DEFUN TIBB (enam / aa bb cc dd bheigt)
  (setq aa (entget enam))
  (setq bb (textbox aa))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
 (* bheigt (pixx)))
 ; Ŀ
 ;   Tibb end.                                                             
 ; 

 ; Ŀ
 ;   Ddx.                                                                  
 ; 
 (DEFUN C:DDX (/ enampt entt typp)
  (setq enampt (entsel "Select anything textlike: "))
  (if enampt
      (progn
           (setq typp (cdr (assoc 0 (setq entt
                                       (entget (setq enam (car enampt)))))))
           (setq rota (cdr (assoc 50 entt)))
           (cond ((or (= typp "TEXT")
                      (= typp "ATTDEF"))
                  (if (getvar "dtexted")
                      (if (or (< (tibb enam) 12)
                              (/= rota 0)
                              (isfo enam "rocket.shx"))
                          (setvar "dtexted" 1)   ; use a dialog box
                          (setvar "dtexted" 0))) ; use flaky onscreen editor
                  (command "ddedit" enam))
                 ((or (= typp "DIMENSION")  ; dtexted has no effect on these
                      (= typp "MTEXT"))
                  (command "ddedit" enam))
                 ((= typp "INSERT")         ; ddedit sucks for blocks
                  (command "ddatte" enam))
                 (T
                  (write-line "\nText, please!."))))
      (write-line "\nNothing selected."))
 (princ))